# 时间管理浏览器插件开发说明文档

## 项目概述
这是一个基于浏览器的时间管理插件，灵感来源于用户提供的时间跟踪界面。插件提供计时器功能、工作记录管理、数据统计分析，支持后台计时和本地数据存储。所有功能默认启用，提供简洁高效的时间管理体验。

## 功能说明
### 核心功能
1. **计时器模块**
   - 开始/暂停/继续/结束计时功能
   - 实时显示当前计时时间
   - **后台计时功能**：关闭插件弹窗后继续计时
   - **状态持久化**：浏览器重启后自动恢复计时状态

2. **工作记录管理**
   - 自动记录计时开始/结束时间
   - 手动添加记录
   - 编辑/删除现有记录
   - 按日期筛选查看记录

3. **数据统计分析**
   - 总工作时间统计
   - 按选择类型分类统计

4. **数据管理**
   - 本地数据存储
   - 导出记录为CSV文件
   - 生成HTML格式工作时间报告
   - 一键删除所有记录

### 设置功能
- 选择类型管理（工作类型的添加、编辑、删除）
- 通知设置

## 技术架构
### 技术栈
- HTML5/CSS3 (UI界面)
- JavaScript (原生，无框架)
- Chrome Extension API (浏览器插件功能)
- Chrome Storage API (数据存储)
- Background Service Worker (后台计时)
- Font Awesome (图标库)

### 项目结构
```
/Test12/
├── README.md
├── css\
│   └── styles.css
├── html\
│   ├── options.html
│   └── popup.html
├── icons\
│   ├── icon128.png
│   ├── icon16.png
│   ├── icon32.png
│   └── icon48.png
├── js\
│   ├── background.js
│   ├── options.js
│   ├── popup.js
│   └── storage.js
├── manifest.json
└── package.json
```

## 数据存储方案
使用Chrome Storage API进行本地数据存储，主要存储以下数据：

1. **用户设置**
```json
{
  "workTypes": ["工作", "生活", "运动", "学习"],
  "notifications": true
}
```

2. **计时器状态**（后台服务）
```json
{
  "isRunning": true,
  "startTime": 1642780800000,
  "pausedDuration": 0,
  "currentType": "工作"
}
```

2. **工作记录**
```json
{
  "records": [
    {
      "id": 1,
      "date": "2025-07-21",
      "startTime": "09:52",
      "endTime": "11:53",
      "duration": 121,
      "content": "高保真图",
      "type": "工作"
    }
  ]
}
```

## 安装与使用
1. 克隆或下载项目到本地
2. 在Chrome浏览器中打开"chrome://extensions/"
3. 启用"开发者模式"
4. 点击"加载已解压的扩展程序"，选择项目目录

## 核心特性

### 🚀 后台计时功能
- **持续计时**：关闭插件弹窗后，计时器在后台继续运行
- **实时同步**：重新打开插件时，立即显示准确的计时时间
- **状态恢复**：浏览器重启后自动恢复计时状态
- **无缝体验**：在不同标签页间切换不影响计时

### 📊 数据管理
- **本地存储**：所有数据安全存储在浏览器本地
- **数据导出**：支持CSV格式导出和HTML报告生成
- **记录管理**：支持手动添加、编辑、删除工作记录
- **智能统计**：按类型和时间段统计工作时长

### ⚙️ 简化设置
- **即开即用**：所有功能默认启用，无需复杂配置
- **类型管理**：自定义工作类型，满足个性化需求
- **界面简洁**：移除冗余开关，专注核心功能

## 注意事项
- 本插件所有数据均存储在浏览器本地，清除浏览器数据可能导致记录丢失
- "一键删除所有记录"功能将永久删除所有工作记录，请谨慎操作
- 建议定期导出数据备份
- 后台计时功能需要保持浏览器运行
- 开发过程中需遵守浏览器插件开发规范